
#include "fp.h"
#include "matfp.hpp"
#include "matfpMath.hpp"
#include "matfpConv.hpp"
#include "matq.h"
#include "matqConv.h"
#include "matqMath.h"
#include "bf.h"
#include "matc.hpp"
#include "matcConv.hpp"
#include "matcMath.hpp"
#include "poly.h"
#include "polyConv.h"
#include "polyMath.h"
#include "polyFactor.h"
#include "mbMod.h"

using namespace std;

// https://en.wikipedia.org/wiki/Factorization_of_polynomials_over_finite_fields#Square-free_factorization

int main (int argc, char * const argv[])
{
    int     m, km, numTrials, countkm, countLess, countMore;
    double  p;
    
again:
    srand(time(NULL));
    
    p = 0;
    while(p<2 || !isItPrime(p, 35))
    {
        cout << "p: ";
        cin >> p;
    }
    //cin.ignore();  // needed for next cin with prompt to behave
    
    m = 0;
    while(m<1)
    {
        cout << "m: ";
        cin >> m;
    }
    cin.ignore();
    
    km = pow(p, m) - 1;
    cout << "km = " << km << endl;

    numTrials = 0;
    while(numTrials<1)
    {
        cout << "numTrials: ";
        cin >> numTrials;
    }
     
    countMatrixGroups(countkm, countLess, countMore, numTrials, m, p);
    
    cout << "countLess = " << countLess << endl;
    cout << "countkm = " << countkm << endl;
    cout << "countMore = " << countMore << endl;
    cout << endl;
    goto again;
    
    return 0;
}
 /*
 clock_t start, end;
 double elapsed;
 
 start = clock();

end = clock();
elapsed = ((double) (end - start)) / CLOCKS_PER_SEC;
 */
